<?php
session_start();
if(!isset($_SESSION['loggedin'])){
    header("Location:login.php");
    return;
}
if ($_SERVER['REQUEST_METHOD'] !== 'POST'){
    header("Location:dashboard.php");
    return;
}
$target_dir = "imgs/";
$target_file = $target_dir . basename($_FILES["advertisment-file"]["name"]);
$uploadOk = 1;
$imageFileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));

$file_name= basename($_FILES["advertisment-file"]["name"]);
// Check if image file is a actual image or fake image
if(isset($_POST["submit"])) {
  $check = getimagesize($_FILES["advertisment-file"]["tmp_name"]);
  if($check !== false) {
    $uploadOk = 1;
  } else {
    $_SESSION["error"]="Image file must be an image ";
    header("Location:dashboard.php");
    return;
  }
}

// Check if file already exists
if (file_exists($target_file)) {
  echo "Sorry, file already exists.";
  $uploadOk = 0;
}

// Check file size
if ($_FILES["advertisment-file"]["size"] > 2000000) {
    $_SESSION["error"]="Image file size must not exceed 2 MB ";
    header("Location:dashboard.php");
    return;
}

// Allow certain file formats
if($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg"
&& $imageFileType != "gif" ) {
    $_SESSION["error"]="Sorry, only JPG, JPEG, PNG & GIF files are allowed. ";
    header("Location:dashboard.php");
    return;
}

if (move_uploaded_file($_FILES["advertisment-file"]["tmp_name"], $target_file)) {
    try {
        $file = './settings.json';
        if(file_exists($file)){
            $data = file_get_contents($file);
            $json_data = json_decode($data, true);
            $json_data['advertismentImage']=$file_name;
            $newJsonString = json_encode($json_data);
            file_put_contents('./settings.json', $newJsonString);
        }else{
            $_SESSION["error"]=" internal error , please try again later or contact support";
            header("Location:dashboard.php");
            return;
        }
        
    }catch(Exception $e){
        $_SESSION["error"]=" internal error , please try again later or contact support";
        header("Location:dashboard.php");
        return;
    }
    $_SESSION["success"]="Image changed Successfully ";
    header("Location:dashboard.php");
    return;  
} else {
    echo "Sorry, there was an error uploading your file.";
  }

?>